%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This program solves simulates the life cycle model for three different values of the IES. 

% It is very similar to SIMULATIONS.m, see that file for more info. 

% Lukasz Rachel, London, 26 March 2019
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all;
close all;

% read in data for simulation

% fiscal exogenous variables
fiscal_sim_data = csvread('gov_sim_data.csv',1,0); %fiscal ratios: debt, G, and social security and healthcare

% demographics and tfp
demog_sim_data = csvread('demog_sim_data.csv',1,0); % read in data for TFP, population growth, gamma (prob of dying) and omega (prob of retiring)

% drop years
year            = demog_sim_data(:,5);
fiscal_sim_data = fiscal_sim_data(:,1:4);
demog_sim_data  = demog_sim_data(:,1:4);

% make them equal length by repeating (repmat) the last value (it's the new
% steady state). always extend the shorter series
T_fiscal = numel(fiscal_sim_data(:,1));
T_demog  = numel(demog_sim_data(:,1));
if T_fiscal < T_demog
    fiscal_sim_data = [fiscal_sim_data; repmat(fiscal_sim_data(T_fiscal,:),T_demog-T_fiscal, 1)];
elseif T_fiscal > T_demog
    demog_sim_data  = [demog_sim_data; repmat(demog_sim_data(T_demog,:),T_fiscal-T_demog, 1)];
else     
end 

% Merge data together
data = [fiscal_sim_data, demog_sim_data];
T    = numel(data(:,1));

% How much of the simulation to keep
T_sim_end = 100;
year_sim = 1971:1:1971+99;

% split the data into deparate variables
bbar_data   = data(:,1);
gbar_data   = data(:,2);
ebar_data   = data(:,3);
hbar_data   = data(:,4);
x_data      = data(:,5);
n_data      = data(:,6);
ggamma_data = data(:,7);
oomega_data = data(:,8);

% Initial SS
% use 1971 values for initial SS
bbar_init_ss     = bbar_data(1);
gbar_init_ss     = gbar_data(1);
ebar_init_ss     = ebar_data(1);
hbar_init_ss     = hbar_data(1);
x_init_ss        = x_data(1);
n_init_ss        = n_data(1);
ggamma_init_ss   = ggamma_data(1);
oomega_init_ss   = oomega_data(1);

% Final SS
bbar_fin_ss      = bbar_data(T);
gbar_fin_ss      = gbar_data(T);
ebar_fin_ss      = ebar_data(T);
hbar_fin_ss      = hbar_data(T);
x_fin_ss         = x_data(T);
n_fin_ss         = n_data(T);
ggamma_fin_ss    = ggamma_data(T);
oomega_fin_ss    = oomega_data(T);



% note that the numbers in the oo_.steady_state will be different than in
% the paper because in the paper we divide most of the variables by
% output. 

% specify values of sigmas
sigmas = [0.33;0.5;0.67];

% Placeholder
R_sim       = zeros(length(sigmas),T_sim_end,numel(data(1,:)));
R_sim_first = zeros(length(sigmas),T_sim_end,numel(data(1,:)));
R_all       = zeros(length(sigmas),T_sim_end);

% Parameter values
aalpha=0.667; %labor share
bbeta=0.98;   %discount factor
ddelta=0.1;   %depreciation
ssigma=0.5;   %IES
ggamma_ss=0.9;%Probability of dying as a retiree
n_ss=1.01;    %Population growth (gross)

% START LOOP OVER SIGMAS

for j=1:length(sigmas)
    
    ssigma = sigmas(j);
    
    save my_parameters.mat aalpha bbeta ddelta ssigma ggamma_ss n_ss
   
    
        % run the initial steady state. 
        dynare gov_initial_ss.mod noclearall;
      
        % run the model feeding in all exogenous variables
        
        % Initial SS
        
        % use 1971 values for initial SS
        bbar_init_ss     = bbar_data(1);
        gbar_init_ss     = gbar_data(1);
        ebar_init_ss     = ebar_data(1);
        hbar_init_ss     = hbar_data(1);
        x_init_ss        = x_data(1);
        n_init_ss        = n_data(1);
        ggamma_init_ss   = ggamma_data(1);
        oomega_init_ss   = oomega_data(1);

        % Final SS
        bbar_fin_ss      = bbar_data(T);
        gbar_fin_ss      = gbar_data(T);
        ebar_fin_ss      = ebar_data(T);
        hbar_fin_ss      = hbar_data(T);
        x_fin_ss         = x_data(T);
        n_fin_ss         = n_data(T);
        ggamma_fin_ss    = ggamma_data(T);
        oomega_fin_ss    = oomega_data(T);

        % Paths
        bbar_data   = data(:,1);
        gbar_data   = data(:,2);
        ebar_data   = data(:,3);
        hbar_data   = data(:,4);
        x_data      = data(:,5);
        n_data      = data(:,6);
        ggamma_data = data(:,7);
        oomega_data = data(:,8);
        
        dynare gov_simulation.mod noclearall
        R_all(j,:) = oo_.endo_simul(2,1:T_sim_end);
       
        
        


        data_loop = repmat(data(1,:),T,1); %start with no exogenous shocks (constant exo)

        number_exo = numel(data(1,:));

        
        % START LOOP OVER EXOGENOUS VARIABLES
        
        for i=1:number_exo

            data_loop(:,i)=data(:,i); %fill in one column at a time

            % generate exo variables paths for dynare
            bbar_data(:) = data_loop(:,1);
            gbar_data(:) = data_loop(:,2);
            ebar_data(:) = data_loop(:,3);
            hbar_data(:) = data_loop(:,4);
            x_data(:)    = data_loop(:,5);
            n_data(:)    = data_loop(:,6);
            ggamma_data  = data_loop(:,7);
            oomega_data  = data_loop(:,8);

            % generate final steady state values
            bbar_fin_ss  = data_loop(T,1);
            gbar_fin_ss  = data_loop(T,2);
            ebar_fin_ss  = data_loop(T,3);
            hbar_fin_ss  = data_loop(T,4);
            x_fin_ss     = data_loop(T,5);
            n_fin_ss     = data_loop(T,6);
            ggamma_fin_ss= data_loop(T,7);
            oomega_fin_ss= data_loop(T,8);

            % Feed shocks one-by-one
            dynare gov_simulation.mod noclearall
            R_sim(j,:,i) = oo_.endo_simul(2,1:T_sim_end)'; %store R
            data_loop = repmat(data(1,:),T,1); %restore clean 'no shock matrix'

        end 
end 

%% Collect the resuls

% R_all: Interest rate response when all shocks fed at once
R_all_tr = R_all';
R_all_inc      = R_all_tr - repmat(R_all_tr(1,:),100,1); %Change from ss

% R_sim: Interest rate response to individual shocks being fed
for j=1:numel(sigmas)
R_sim_first(j,:,:)    = repmat(R_sim(j,1,:),numel(R_sim(j,:,1)),1);
end 

% for 3 different calibrations
R_sim_inc_low = squeeze(R_sim(1,:,:)-R_sim_first(1,:,:));
R_sim_inc_med = squeeze(R_sim(2,:,:)-R_sim_first(2,:,:));
R_sim_inc_hig = squeeze(R_sim(3,:,:)-R_sim_first(3,:,:));

% Construct table in Excel
Impact_to_date = 100*[R_sim_inc_low(49,:);R_sim_inc_med(49,:);R_sim_inc_hig(49,:);]';
Impact_Robust = [Impact_to_date ; 100*R_all_inc(49,:) - sum(Impact_to_date,1); sum(Impact_to_date,1); 100*R_all_inc(49,:)];

% Paste Impact_to_date_complete matrix into /Users/lukaszrachel/Documents/Research/Research_ideas/Laubach Williams for the World/Gertler 1999 - simulations/Decomposition of the decline in Aeqm real rate.xlsx
% tab: robustness.









